function [baseMVA, bus, gen, branch, area, gencost] = esca64_n2

%ESCA64_N2    Defines the power flow data in a format similar to PTI.
%   [baseMVA, bus, gen, branch, area, gencost] = esca64_n
%   The format for the data is similar to PTI format except where noted.
%   An item marked with (+) indicates that it is included in this data
%   but is not part of the PTI format. An item marked with (-) is one that
%   is in the PTI format but is not included here.
%
%   Bus Data Format
%       1   bus number (1 to 29997)
%       2   bus type
%               PQ bus          = 1
%               PV bus          = 2
%               reference bus   = 3
%               isolated bus    = 4
%       3   Pd, real power demand (MW)
%       4   Qd, reactive power demand (MVAR)
%       5   Gs, shunt conductance (MW (demanded?) at V = 1.0 p.u.)
%       6   Bs, shunt susceptance (MVAR (injected?) at V = 1.0 p.u.)
%       7   area number, 1-100
%       8   Vm, voltage magnitude (p.u.)
%       9   Va, voltage angle (degrees)
%   (-)     (bus name)
%       10  baseKV, base voltage (kV)
%       11  zone, loss zone (1-999)
%   (+) 12  maxVm, maximum voltage magnitude (p.u.)
%   (+) 13  minVm, minimum voltage magnitude (p.u.)
%
%   Generator Data Format
%       1   bus number
%   (-)     (machine identifier, 0-9, A-Z)
%       2   Pg, real power output (MW)
%       3   Qg, reactive power output (MVAR)
%       4   Qmax, maximum reactive power output (MVAR)
%       5   Qmin, minimum reactive power output (MVAR)
%       6   Vg, voltage magnitude setpoint (p.u.)
%   (-)     (remote controlled bus index)
%       7   mBase, total MVA base of this machine, defaults to baseMVA
%   (-)     (machine impedance, p.u. on mBase)
%   (-)     (step up transformer impedance, p.u. on mBase)
%   (-)     (step up transformer off nominal turns ratio)
%       8   status, 1 - machine in service, 0 - machine out of service
%   (-)     (% of total VARS to come from this gen in order to hold V at
%               remote bus controlled by several generators)
%       9   Pmax, maximum real power output (MW)
%       10  Pmin, minimum real power output (MW)
%
%   Branch Data Format
%       1   f, from bus number
%       2   t, to bus number
%   (-)     (circuit identifier)
%       3   r, resistance (p.u.)
%       4   x, reactance (p.u.)
%       5   b, total line charging susceptance (p.u.)
%       6   rateA, MVA rating A (long term rating)
%       7   rateB, MVA rating B (short term rating)
%       8   rateC, MVA rating C (emergency rating)
%       9   ratio, transformer off nominal turns ratio ( = 0 for lines )
%           (taps at 'from' bus, impedance at 'to' bus, i.e. ratio = Vf / Vt)
%       10  angle, transformer phase shift angle (degrees)
%   (-)     (Gf, shunt conductance at from bus p.u.)
%   (-)     (Bf, shunt susceptance at from bus p.u.)
%   (-)     (Gt, shunt conductance at to bus p.u.)
%   (-)     (Bt, shunt susceptance at to bus p.u.)
%       11  initial branch status, 1 - in service, 0 - out of service
%
% (+) Area Data Format
%       1   i, area number
%       2   price_ref_bus, reference bus for that area
% 
% (+) Generator Cost Data Format
%       NOTE: If gen has n rows, then the first n rows of gencost contain
%       the cost for active power produced by the corresponding generators.
%       If gencost has 2*n rows then rows n+1 to 2*n contain the reactive
%       power costs in the same format.
%       1   model, 1 - piecewise linear, 2 - polynomial
%       2   startup, startup cost in US dollars
%       3   shutdown, shutdown cost in US dollars
%       4   n, number of cost coefficients to follow for polynomial
%           (or data points for piecewise linear) total cost function
%       5 and following, cost data, piecewise linear data as:
%                   x0, y0, x1, y1, x2, y2, ...
%           and polynomial data as, e.g.:
%                   c2, c1, c0
%           where the polynomial is c0 + c1*P + c2*P^2
%
% << this file created [99-Nov-11 11:10:15] by AJF >>

%%-----  Power Flow Data  -----%%

%% system MVA base
baseMVA = 100.0000;


%ESCA 64 Bus System - PTI RAW Format

%% bus data
bus = [
     1  1       0.000      0.000      0.000      0.000   1 0.99095    -5.2076   345.00    1  1.05  0.95;
     2  1       0.000      0.000      0.000      0.000   1 0.99105    -5.1886   345.00    1  1.05  0.95;
     3  1     389.037     68.620      0.000      0.000   1 0.98465    -4.5852   138.00    1  1.05  0.95;
     4  2       0.000      0.000      0.000      0.000   1 1.00830    -2.5810    22.00    1  1.05  0.95;
     5  2       0.000      0.000      0.000      0.000   1 0.99620     0.2819    13.80    1  1.05  0.95;
     6  1       0.000      0.000      0.000      0.000   1 0.97770    -4.0152   345.00    1  1.05  0.95;
     7  1       0.000      0.000      0.000      0.000   1 0.97779    -4.0184   345.00    1  1.05  0.95;
     8  2       6.340      4.220      0.000      0.000   1 0.94500     0.1032    13.80    1  1.05  0.95;
     9  2       6.340      4.220      0.000      0.000   1 0.94500     0.1032    13.80    1  1.05  0.95;
    10  1       0.000      0.000      0.000      0.000   1 0.97317    -7.3821   345.00    1  1.05  0.95;
    11  1      86.999     41.800      0.000      0.000   1 0.97865    -8.0723    22.00    1  1.05  0.95;
    12  1      20.720      3.400      0.000      0.000   1 0.99015    -8.0312    13.80    1  1.05  0.95;
    13  1       0.000      0.000      0.000      0.000   1 0.97635    -7.9066     1.00    1  1.05  0.95;
    14  1     101.739     37.920      0.000      0.000   1 0.98483    -4.3443   345.00    1  1.05  0.95;
    15  2       0.000      0.000      0.000      0.000   1 1.02500     0.6460    22.00    1  1.05  0.95;
    16  1       0.000      0.000      0.000      0.000   2 0.98572   -10.1238   345.00    2  1.05  0.95;
    17  1     184.659     35.080      0.000      0.000   2 0.99050   -10.1539   345.00    2  1.05  0.95;
    18  1       0.000      0.000      0.000      0.000   2 0.97880   -10.5547   345.00    2  1.05  0.95;
    19  1     328.418     88.259      0.000      0.000   2 0.92074   -12.5611   138.00    2  1.05  0.95;
    20  1     384.977     37.720      0.000      0.000   2 0.97528    -9.7684   345.00    2  1.05  0.95;
    21  1       0.000      0.000      0.000      0.000   2 0.98131   -10.0767   345.00    2  1.05  0.95;
    22  1       0.000      0.000      0.000     50.000   2 0.97547   -10.6533   345.00    2  1.05  0.95;
    23  1       0.000      0.000      0.000    170.000   2 0.92204   -12.7106   138.00    2  1.05  0.95;
    24  1     158.759     95.439      0.000      0.000   2 0.87891   -14.8362    22.00    2  1.05  0.95;
    25  1     209.499     81.059      0.000      0.000   2 0.89278   -16.8089    22.00    2  1.05  0.95;
    26  1       5.700      2.320      0.000      0.000   2 0.90193   -15.3592    13.80    2  1.05  0.95;
    27  1       0.000      0.000      0.000      0.000   2 0.90219   -15.3191     1.00    2  1.05  0.95;
    28  1     376.418      2.840      0.000      0.000   2 1.00242    -8.8216   345.00    2  1.05  0.95;
    29  1       0.000      0.000      0.000      0.000   2 0.96993   -10.0923   345.00    2  1.05  0.95;
    30  1       0.000      0.000      0.000      0.000   2 0.91479   -12.4672   138.00    2  1.05  0.95;
    31  1     209.619    132.979      0.000      0.000   2 0.86189   -15.4266    22.00    2  1.05  0.95;
    32  1      86.879     10.040      0.000      0.000   2 0.90711   -14.9164    22.00    2  1.05  0.95;
    33  1      64.160     15.100      0.000      0.000   2 0.90657   -14.7586    13.80    2  1.05  0.95;
    34  1       0.000      0.000      0.000      0.000   2 0.90827   -14.3123     1.00    2  1.05  0.95;
    35  1       0.000      0.000      0.000      0.000   2 1.01966    -7.0580   345.00    3  1.05  0.95;
    36  2       0.000      0.000      0.000      0.000   2 1.06380    -1.7901    13.80    3  1.05  0.95;
    37  1       0.000      0.000      0.000      0.000   2 1.01634    -7.5062   345.00    3  1.05  0.95;
    38  1       0.000      0.000      0.000      0.000   2 1.01604    -7.9866   345.00    3  1.05  0.95;
    39  1     133.659     48.040      0.000      0.000   2 0.98141    -9.2885    22.00    3  1.05  0.95;
    40  1       0.000      0.000      0.000      0.000   2 0.99778    -6.3354   345.00    3  1.05  0.95;
    41  1       0.000      0.000      0.000      0.000   2 0.98713    -6.6295   345.00    3  1.05  0.95;
    42  1       4.860     50.300      0.000      0.000   2 0.96891    -6.5193   138.00    3  1.05  0.95;
    43  1       0.000      0.000      0.000      0.000   2 0.99873    -9.0507   345.00    3  1.05  0.95;
    44  1     159.979     47.100      0.000      0.000   2 0.98760   -10.8505    13.80    3  1.05  0.95;
    45  1     174.239     26.140      0.000      0.000   2 0.99157   -11.0148    13.80    3  1.05  0.95;
    46  1       0.000      0.000      0.000      0.000   2 1.03740    -6.2402   345.00    3  1.05  0.95;
    47  1       0.000      0.000      0.000      0.000   2 0.98971    -8.3151   345.00    3  1.05  0.95;
    48  1       0.000      0.000      0.000      0.000   2 1.01653    -8.1188   345.00    3  1.05  0.95;
    49  1     129.159     27.560      0.000      0.000   2 1.01025    -9.4557    13.80    3  1.05  0.95;
    50  1     117.479     24.140      0.000      0.000   2 1.01102    -9.3342    13.80    3  1.05  0.95;
    51  1       0.000      0.000      0.000      0.000   2 0.98701    -5.9214   345.00    3  1.05  0.95;
    52  2       0.000      0.000      0.000      0.000   2 0.86350     0.1154    13.80    3  1.05  0.95;
    53  1     199.999     62.700      0.000      0.000   3 1.02288    -3.9827   345.00    4  1.05  0.95;
    54  1       0.000      0.000      0.000      0.000   3 1.02274    -3.9985   345.00    4  1.05  0.95;
    55  2       0.000      0.000      0.000      0.000   3 1.02500     1.2146    13.80    4  1.05  0.95;
    56  1    -107.659     73.700      0.000      0.000   3 1.03871    -2.4411   345.00    4  1.05  0.95;
    57  2       0.000      0.000      0.000      0.000   3 1.02000     1.7411    13.80    4  1.05  0.95;
    58  1     454.317    102.859      0.000    -95.000   3 1.03139    -4.9024   345.00    4  1.05  0.95;
    59  3       0.000      0.000      0.000      0.000   3 1.01910     0.0000    13.80    4  1.05  0.95;
    60  1      84.759     11.340      0.000     63.900   3 1.03555    -3.5871   345.00    4  1.05  0.95;
    61  1      57.200      6.980      0.000     63.450   3 1.03039    -4.7346   345.00    4  1.05  0.95;
    62  1     116.659     11.040      0.000     24.500   3 1.03440    -1.6848   345.00    4  1.05  0.95;
    63  2       0.000      0.000      0.000      0.000   3 1.00880     2.2043    22.00    4  1.05  0.95;
    64  1       0.000      0.000      0.000      0.000   3 1.03969    -4.5993   345.00    4  1.05  0.95];
 %% generator data
gen = [
    4    325.8    113.7    300.0   -150.0  1.01000    100.000   1  400.0      0.0;
    5    465.4     60.3    450.0   -200.0  1.01000    100.000   1  550.0      0.0;
    8    232.7    -16.9    250.0   -100.0  1.00000    100.000   1  350.0      0.0;
    9    232.7    -16.9    250.0   -100.0  1.00000    100.000   1  350.0      0.0;
   15    325.8    159.5    350.0   -200.0  1.02500    100.000   1  400.0      0.0;
   36    372.3    400.0    400.0   -200.0  1.05000    100.000   1  450.0      0.0;
   52    418.8   -232.4    400.0   -250.0  1.01500    100.000   1  500.0      0.0;
   55    511.9    176.5    550.0   -300.0  1.02500    100.000   1  650.0      0.0;
   57    325.8     32.6    300.0   -150.0  1.02000    100.000   1  400.0      0.0;
   59    530.5     85.6   1600.0   -800.0  1.05000    100.000   1 1600.0      0.0;
   63    442.1    -10.0    450.0   -300.0  1.05000    100.000   1  550.0      0.0];
 %% branch data
branch = [
    1     20    0.00320   0.03900   0.15200   875.00   912.50   950.00  0.00000    0.00    1;
    1     20    0.00320   0.03900   0.15200   875.00   912.50   950.00  0.00000    0.00    1;
    6     10    0.00080   0.01400   0.25700   660.00   710.00   760.00  0.00000    0.00    1;
    7     14    0.00060   0.00960   0.18500   605.00   680.00   775.00  0.00000    0.00    1;
   10     20    0.00080   0.01350   0.25500   500.00   550.00   625.00  0.00000    0.00    1;
   14     29    0.00220   0.03500   0.36100   600.00   675.00   750.00  0.00000    0.00    1;
   16     21    0.00070   0.00820   0.13200   600.00   675.00   750.00  0.00000    0.00    1;
   17     28    0.00110   0.01330   0.21400   600.00   675.00   750.00  0.00000    0.00    1;
   18     61    0.00320   0.03400   0.51000   600.00   675.00   750.00  0.00000    0.00    1;
   18     21    0.00130   0.01730   0.32200   600.00   675.00   750.00  0.00000    0.00    1;
   19     30    0.00112   0.00673   0.05049   600.00   675.00   750.00  0.00000    0.00    1;
   19     23    0.00092   0.00554   0.04158   600.00   675.00   750.00  0.00000    0.00    1;
   20     29    0.00030   0.00590   0.06800   600.00   675.00   750.00  0.00000    0.00    1;
   20     21    0.00070   0.00890   0.13400   600.00   675.00   750.00  0.00000    0.00    1;
   20     22    0.00090   0.00940   0.17100   600.00   675.00   750.00  0.00000    0.00    1;
   22     47    0.00180   0.02170   0.36600   600.00   675.00   750.00  0.00000    0.00    1;
   28     54    0.00130   0.01510   0.25700   750.00   750.00   800.00  0.00000    0.00    1;
   28     43    0.00130   0.02130   0.22100   600.00   675.00   750.00  0.00000    0.00    1;
   35     37    0.00020   0.00260   0.04300   600.00   675.00   750.00  0.00000    0.00    1;
   35     38    0.00060   0.00920   0.11300   600.00   675.00   750.00  0.00000    0.00    1;
   35     40    0.00070   0.00820   0.13900   600.00   675.00   750.00  0.00000    0.00    1;
   37     43    0.00080   0.01280   0.13400   600.00   675.00   750.00  0.00000    0.00    1;
   37     48    0.00080   0.01120   0.14800   600.00   675.00   750.00  0.00000    0.00    1;
   38     48    0.00040   0.00460   0.07800   600.00   675.00   750.00  0.00000    0.00    1;
   40     51    0.00040   0.00430   0.07300   600.00   675.00   750.00  0.00000    0.00    1;
   41     51    0.00040   0.00430   0.07300   600.00   675.00   750.00  0.00000    0.00    1;
   41     47    0.00090   0.01010   0.17200   600.00   675.00   750.00  0.00000    0.00    1;
   43     47    0.00080   0.01290   0.13800   600.00   675.00   750.00  0.00000    0.00    1;
   46     58    0.00100   0.02500   1.20000   600.00   675.00   750.00  0.00000    0.00    1;
   46     48    0.00230   0.03630   0.38000   600.00   675.00   750.00  0.00000    0.00    1;
   53     64    0.00350   0.04110   0.69900   600.00   675.00   750.00  0.00000    0.00    1;
   54     56    0.00700   0.00860   0.14600   600.00   675.00   750.00  0.00000    0.00    1;
   56     61    0.00320   0.03230   0.51300   600.00   675.00   750.00  0.00000    0.00    1;
   58     64    0.00100   0.02500   0.75000   600.00   675.00   750.00  0.00000    0.00    1;
    1      2    0.00000   0.00010   0.00000   700.00   775.00   850.00  0.00000    0.00    1;
    7      6    0.00000   0.00010   0.00000   600.00   675.00   750.00  0.00000    0.00    1;
   54     53    0.00000   0.00010   0.00000   600.00   675.00   750.00  0.00000    0.00    1;
    1      3    0.00070   0.01380   0.00000  1000.00  1100.00  1200.00  1.00000    0.00    1;
    3      5    0.00090   0.01800   0.00000  1000.00  1100.00  1200.00  1.00000    0.00    1;
    2      4    0.00070   0.01420   0.00000   750.00   800.00   900.00  1.00000    0.00    1;
    6      8    0.00000   0.02860   0.00000   600.00   675.00   750.00  1.02500    0.00    1;
    6      9    0.00000   0.02860   0.00000   600.00   675.00   750.00  1.02500    0.00    1;
   11     10    0.00070   0.01970   0.00000   600.00   675.00   750.00  1.02000    0.00    1;
   10     13    0.00050   0.01780   0.00000   600.00   675.00   750.00  1.00000    0.00    1;
   11     13    0.00001   0.01000   0.00000   600.00   675.00   750.00  1.00000    0.00    1;
   12     13    0.00001   0.01000   0.00000   600.00   675.00   750.00  1.01450    0.00    1;
   14     15    0.00050   0.02720   0.00000   800.00   900.00  1000.00  1.00000    0.00    1;
   17     16    0.00000   0.01000   0.00000   600.00   675.00   750.00  1.00000    0.00    1;
   19     18    0.00080   0.01880   0.00000   600.00   675.00   750.00  0.95600    0.00    1;
   19     18    0.00080   0.01880   0.00000   600.00   675.00   750.00  0.95600    0.00    1;
   23     22    0.00075   0.02010   0.00000   600.00   675.00   750.00  0.95600    0.00    1;
   23     22    0.00075   0.02010   0.00000   600.00   675.00   750.00  0.95600    0.00    1;
   24     23    0.00090   0.01990   0.00000   600.00   675.00   750.00  0.97800    0.00    1;
   23     27    0.00050   0.01780   0.00000   600.00   675.00   750.00  1.00000    0.00    1;
   25     27    0.00001   0.01000   0.00000   600.00   675.00   750.00  1.00000    0.00    1;
   26     27    0.00001   0.01000   0.00000   600.00   675.00   750.00  1.00000    0.00    1;
   30     29    0.00080   0.02110   0.00000   600.00   675.00   750.00  0.95600    0.00    1;
   30     29    0.00080   0.02110   0.00000   600.00   675.00   750.00  0.95600    0.00    1;
   31     30    0.00070   0.02030   0.00000   600.00   675.00   750.00  0.97800    0.00    1;
   30     34    0.00050   0.01780   0.00000   600.00   675.00   750.00  1.00000    0.00    1;
   32     34    0.00001   0.01000   0.00000   600.00   675.00   750.00  1.00000    0.00    1;
   33     34    0.00001   0.01000   0.00000   600.00   675.00   750.00  1.00000    0.00    1;
   35     36    0.00000   0.02500   0.00000   900.00  1000.00  1100.00  1.07000    0.00    1;
   39     38    0.00060   0.01760   0.00000   600.00   675.00   750.00  0.97500    0.00    1;
   42     40    0.00160   0.04350   0.00000   600.00   675.00   750.00  0.98120    0.00    1;
   42     41    0.00160   0.04350   0.00000   600.00   675.00   750.00  0.99370    0.00    1;
   44     43    0.00080   0.01960   0.00000   600.00   675.00   750.00  1.00000    0.00    1;
   45     43    0.00080   0.01960   0.00000   600.00   675.00   750.00  1.00000    0.00    1;
   49     48    0.00070   0.01870   0.00000   600.00   675.00   750.00  1.00000    0.00    1;
   50     48    0.00070   0.01870   0.00000   600.00   675.00   750.00  1.00000    0.00    1;
   51     52    0.00000   0.02000   0.00000  1000.00  1100.00  1200.00  1.07000    0.00    1;
   53     55    0.00000   0.01810   0.00000  1300.00  1400.00  1500.00  1.02500    0.00    1;
   56     57    0.00060   0.02320   0.00000   800.00   900.00  1000.00  1.02500    0.00    1;
   58     59    0.00050   0.01660   0.00000  2000.00  2200.00  2300.00  1.02500    0.00    1;
   62     63    0.00080   0.01560   0.00000  1100.00  1200.00  1300.00  1.02500    0.00    1;
   60     62    0.00140   0.01510   0.00000   600.00   675.00   750.00  0.00000    0.00    1;
   61     60    0.00140   0.01470   0.00000   600.00   675.00   750.00  0.00000    0.00    1;
   61     62    0.00570   0.06250   0.00000   600.00   675.00   750.00  0.00000    0.00    1];

%%-----  OPF Data  -----%%
%% area data
area = [
   1   5;
   2   5;
   3   5;
];

%% generator cost data
gencost = [
   2   1500.00   0.00   3   0.1100  5.0   150;
   2   2000.00   0.00   3   0.0850  1.2   600;
   2   3000.00   0.00   3   0.1225  1.0   335;
   2   1500.00   0.00   3   0.1100  5.0   150;
   2   2000.00   0.00   3   0.0850  1.2   600;
   2   3000.00   0.00   3   0.1225  1.0   335;
   2   1500.00   0.00   3   0.1100  5.0   150;
   2   2000.00   0.00   3   0.0850  1.2   600;
   2   3000.00   0.00   3   0.1225  1.0   335;
   2   1500.00   0.00   3   0.1100  5.0   150;
   2   2000.00   0.00   3   0.0850  1.2   600;
];

return;
